const mongoose =  require('mongoose');

const directorySchema = mongoose.Schema({
    documentStatus: {
        authorizationSTPS: {
            isRequired: {
                type: Boolean,
                default: true
            }, 
            status: {
                type: Boolean,
                default: false
            }
        },
        Documents: {
            isRequired: {
                type: Boolean,
                default: true
            }, 
            status: {
                type: Boolean,
                default: false
            }
        },
        InformacionDeContacto : {
            isRequired: {
                type: Boolean,
                default: false
            }, 
            status: {
                type: Boolean,
                default: false
            }
        },
        DocumentacionCorporativa : {
            isRequired: {
                type: Boolean,
                default: false
            }, 
            status: {
                type: Boolean,
                default: false
            }
        },
        Contrato: {
            isRequired: {
                type: Boolean,
                default: false
            }, 
            status: {
                type: Boolean,
                default: false
            }
        }
    }, 

    documents : {
        nonRecurring: [
            {
                name : {type: String},
                value: [{type: mongoose.Schema.Types.ObjectId, ref: 'Document'}],
                isValidated:{type:Boolean, default:false} 
            }
        ], 
        reccuring: [
            {
                year : {
                    type: String
                },
                months: [
                    {
                        month : {
                            type: String,
                            enum:[1, 2,3, 4, 5, 6, 7, 8,9, 10,11,12],
                        },
                        documents : [
                            {
                                name : {type: String},
                                value: [{type: mongoose.Schema.Types.ObjectId, ref: 'Document'}],
                                isRequired: {type:Boolean, default:true},
                                isValidated:{type:Boolean, default:false},
                                documents: [
                                    {
                                        name : {type: String},
                                        value: [{type: mongoose.Schema.Types.ObjectId, ref: 'Document'}],
                                        isRequired: {type:Boolean, default:true},
                                        isValidated:{type:Boolean, default:false}
                                    }
                                ],
                            }

                        ],
                        islocked : {type:String , default:false}

                    }
                ]
            }
        ]
    }
});

module.exports =  mongoose.model('Directory', directorySchema);




/* Demo JSON Structure for basic understanding */ 


// {
   
//     "documents" : {
//         "root" : [
//             {
//                 "name":"authorization_STPS",
//                 "value":["document_id","document_ids"]
//             },
//             {
//                 "name":"Estatutos",
//                 "value":["document_id","document_ids"]
//             },
//             {
//                 "name":"Contrato",
//                 "value":["document_id","document_ids"]
//             }
//         ],
//         "documents" : [
//             {
//                 "year":"2020",
//                 "months": [
//                     {
//                         "month":11,
//                         "documents" : {
//                             "CFDI": ["document_id","document_ids"],
//                             "Declaratio Retensio" : ["document_id","document_ids"],
//                             "SUA IMSS" : ["document_id","document_ids"],
//                             "PAGO IMSS" : ["document_id","document_ids"],
//                             "PAGO IVA" : ["document_id","document_ids"],
//                             "RETENTIO IVA" : ["document_id","document_ids"],
//                             "OPINION IMSS" : ["document_id","document_ids"],
//                             "OPINION SAT" : ["document_id","document_ids"]
//                         }
//                     },
//                     {
//                         "month":12,
//                         "documents" : {
//                             "CFDI": ["document_id","document_ids"],
//                             "Declaratio Retensio" : ["document_id","document_ids"],
//                             "SUA IMSS" : ["document_id","document_ids"],
//                             "PAGO IMSS" : ["document_id","document_ids"],
//                             "PAGO IVA" : ["document_id","document_ids"],
//                             "RETENTIO IVA" : ["document_id","document_ids"],
//                             "OPINION IMSS" : ["document_id","document_ids"],
//                             "OPINION SAT" : ["document_id","document_ids"]
//                         }
//                     }

//             ]
//         },
//         {
//             "year":"2021",
//             "months": [
//                 {
//                     "month":1,
//                     "documents" : {
//                         "CFDI": ["document_id","document_ids"],
//                         "Declaratio Retensio" : ["document_id","document_ids"],
//                         "SUA IMSS" : ["document_id","document_ids"],
//                         "PAGO IMSS" : ["document_id","document_ids"],
//                         "PAGO IVA" : ["document_id","document_ids"],
//                         "RETENTIO IVA" : ["document_id","document_ids"],
//                         "OPINION IMSS" : ["document_id","document_ids"],
//                         "OPINION SAT" : ["document_id","document_ids"]
//                     }
//                 },
//                 {
//                     "month":2,
//                     "documents" : {
//                         "CFDI": ["document_id","document_ids"],
//                         "Declaratio Retensio" : ["document_id","document_ids"],
//                         "SUA IMSS" : ["document_id","document_ids"],
//                         "PAGO IMSS" : ["document_id","document_ids"],
//                         "PAGO IVA" : ["document_id","document_ids"],
//                         "RETENTIO IVA" : ["document_id","document_ids"],
//                         "OPINION IMSS" : ["document_id","document_ids"],
//                         "OPINION SAT" : ["document_id","document_ids"]
//                     }
//                 }
//             ]
//         } 
//     ]
// }
// }