const Directory = require('../models/directory');
const accountsRelations = require('../models/accountsRelations');
const ClientContactInformation = require('../models/clientContactInformation');
const ProviderContactInformation = require('../models/providerContactInformation');
const objectId = require('mongoose').Types.ObjectId;

const {
    checkIfDirectoryBelongsToUser,
    findIndexOnObject,
    cleanUpDocumentData,
    ParseXMLFromDocument,
    parsePDFDataFromDocument,
    checkDisperancy,
    addYearsToDirectory,
    addMonthsToDirectory,
    checkAutorizacionSTPSDocStatus,
    checkDirectoryDataStatus,
    MonthFolderLockstatus,
    getdirectoryDetailsbyProvider,
    ReportDirectoryStatus,
    checkreportFromDocument
} = require('../helper');

const meses =  [
    {
      "id": 1,
      "nombre": "Enero"
    },
    {
      "id": 2,
      "nombre": "Febrero"
    },
    {
      "id": 3,
      "nombre": "Marzo"
    },
    {
      "id": 4,
      "nombre": "Abril"
    },
    {
      "id": 5,
      "nombre": "Mayo"
    },
    {
      "id": 6,
      "nombre": "Junio"
    },
    {
      "id": 7,
      "nombre": "Julio"
    },
    {
      "id": 8,
      "nombre": "Agosto"
    },
    {
      "id": 9,
      "nombre": "Septiembre"
    },
    {
      "id": 10,
      "nombre": "Octubre"
    },
    {
      "id": 11,
      "nombre": "Noviembre"
    },
    {
      "id": 12,
      "nombre": "Diciembre"
    }
  ];
/* Document Function. */
module.exports = {
    getReport: async(req, res) => {
        try{
            const {provider, year, months,folders} = req.body;
            if(provider && year && months && folders){
              let resData=[];
              for (let i = 0; i < provider.length; i++) {
                  providerId=provider[i];
                  const getDirectoryDetails = await getdirectoryDetailsbyProvider(providerId,req.user._id);
                  const directory_id=getDirectoryDetails.directoryId.toString();
                  const providerName=getDirectoryDetails.providername;
                  let monthArray=[];
                  let providerdata={};
                  providerdata.providername=providerName;
                  const promises = months.map(async (monthno) => { 
                      let foldersArray=[];
                      const user = req.user;
                      const isOwnedByUser = await checkIfDirectoryBelongsToUser(directory_id,req.user._id)
                      if(isOwnedByUser){
                        const directoryData =await Directory.findOne({_id: objectId(directory_id)}).lean();
                        if(directoryData){
                              const documents = directoryData.documents;
                              const result = await checkreportFromDocument(directory_id, year, monthno, documents,folders);
                              foldersArray.push(result);
                              let monthName = meses.find(_mes => _mes.id == monthno).nombre;
                              let monthsobject={"month":monthName,"folders":foldersArray}
                              return monthsobject;
                        }
                      }
                  });
                  const monthlyDataObject = await Promise.all(promises);
                  monthArray.push(monthlyDataObject);
                  providerdata.report=monthlyDataObject;
                  resData.push(providerdata);
              }
              res.status(200);
              return res.send({
                  data: resData
              });
            } else {
                res.status(400);
                return res.send({Error: "Invalid request"});
            }
        }catch(e){
            console.log(e);
            res.status(400);
            return res.send({Error: "Something Went wrong, Please Try Again"});
        }
    },

}