const User = require('../models/user');
const objectId = require('mongoose').Types.ObjectId;
const AccountsRelations = require('../models/accountsRelations');
const VendorRegistrationMap = require('../models/vendorRegistrationMap'); 
const {SendRegistrationLinkViaEmailToProvider} = require('../helper');
/* Dashboard Function. */

module.exports = {
    getClientsOrProvidersForAUser : async(req,res) => {
        try{
        
        // Fetch Authenticated User Data
        const authenticatedUserRole = await User.findById(req.user._id).select('roles').lean();

        let usersMappedToAccount = [];

        // Based on roles fetch data for the users
        if(authenticatedUserRole.roles == "client"){
            
            usersMappedToAccount = await AccountsRelations.find({ clientId: req.user._id,status:'active'})
            .select('providerId')
            .select("directory")
            .populate({path: 'directory', select: '_id' })
            .populate({path: 'providerId', select: 'name email roles rfc' })
            .lean();

        }else if(authenticatedUserRole.roles == "subclient") {
            const user = await User.findOne({_id: req.user._id}).lean();
            usersMappedToAccount = await AccountsRelations.find({ clientId: user.clientId,status:'active'})
            .select('providerId')
            .select("directory")
            .populate({path: 'directory', select: '_id' })
            .populate({path: 'providerId', select: 'name email roles rfc' })
            .lean();
        }else{

            usersMappedToAccount = await AccountsRelations.find({ providerId: req.user._id,status:'active'})
            .select('clientId')
            .select("directory")
            .populate({path: 'directory', select: '_id' })
            .populate({path: 'clientId', select: 'name email roles rfc' })
            .lean();
        }
        

        res.status(200);
        return res.send(usersMappedToAccount);

        }catch(e){
            console.log(e);
            res.status(400);
            return res.send({Error: "Something Went wrong, Please Try Again"});
        }
    },
    getInvitedVendorsInformation : async(req,res) => {
        try{
            // Fetch Authenticated User Data
            const authenticatedUser = await User.findById(req.user._id);

            if(authenticatedUser.roles == "client"){
                // get all vendors for the clientId
                const vendors_invited = await VendorRegistrationMap.find({clientId: authenticatedUser._id});

                const filterd_vendors = vendors_invited.map((singleVendor) => {
                    return {
                        status: singleVendor.status,
                        email: singleVendor.providerEmail,
                        rfc: singleVendor.RFCId,
                        id: singleVendor._id
                    }
                });
                res.status(200);
                return res.send(filterd_vendors);

            }else{
                res.status(400);
                return res.send({Error: "Only Client can send vendor registration invitations"});
            }

        }catch(e){
            console.log(e);
            res.status(400);
            return res.send({Error: "Something Went wrong, Please Try Again"});
        }
    }, 
    resendInvitationForVendor: async(req,res) => {
        try{
            const {id} = req.body;

            // Fetch Authenticated User Data
            const authenticatedUser = await User.findById(req.user._id);

            if(authenticatedUser.roles == "client" && id){
                // get all vendors for the clientId
                const vendor = await VendorRegistrationMap.findById(id);
                if(!vendor || vendor.status != "pending"){
                    res.status(200);
                    return res.send({Error: "No Vendors Found"});
                }
                SendRegistrationLinkViaEmailToProvider(vendor.providerEmail, authenticatedUser.name,authenticatedUser.email,vendor.RFCId)
                res.status(200);
                return res.send({message: `Email was send Again to ${vendor.providerEmail}`});

            }else{
                res.status(400);
                return res.send({Error: "Only Client can send vendor registration invitations"});
            }

        }catch(e){
            console.log(e);
            res.status(400);
            return res.send({Error: "Something Went wrong, Please Try Again"});
        }
    }
}