const express = require('express');
const router = express.Router();
const passport = require('passport');
const {login,verify,registration,resetPassword,resendOTP} = require('../src/controllers/auth');

/* Login. */
router.post('/login', login);

/* Sign up process */
router.post('/signup',passport.authenticate('signup', { session: false }), registration);

/* VERIFY EMAIL */
router.post('/verify_email',verify);

/* RESET PASSWORD */
router.post(['/reset_password','/reset_password/verify'],resetPassword);     
 
/* RESEND OTP */
router.get('/resend_otp',resendOTP);

module.exports = router;