# Armenian (hy) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                   | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987֊րդ                                           | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5֊րդ                                              | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987֊րդ                                           | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5֊րդ                                              | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1֊ին                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2֊րդ                                              | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | Ք1                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Ք2                                                | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1֊ին քառորդ                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2֊րդ քառորդ                                       | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                 | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1֊ին                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2֊րդ                                              | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | Ք1                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Ք2                                                | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1֊ին քառորդ                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2֊րդ քառորդ                                       | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2֊րդ                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7֊րդ                                              | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | փետ                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | հուլ                                              | 2019-01-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | փետրվար                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | հուլիս                                            | 2019-01-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | Փ                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Հ                                                 | 2019-01-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2֊րդ                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7֊րդ                                              | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | փետ                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | հուլ                                              | 2019-01-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | փետրվար                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | հուլիս                                            | 2019-01-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | Փ                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Հ                                                 | 2019-01-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1֊ին                                              | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48֊րդ                                             | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1֊ին                                              | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48֊րդ                                             | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11֊րդ                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28֊րդ                                             | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42֊րդ                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365֊րդ                                            | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | երկ                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ուրբ                                              | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | երկ                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ուրբ                                              | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | երկ                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ուրբ                                              | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | երկուշաբթի                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ուրբաթ                                            | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | Ե                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ո                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | եր                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ուր                                               | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1֊ին                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5֊րդ                                              | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | երկ                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ուրբ                                              | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | երկուշաբթի                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ուրբաթ                                            | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | Ե                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ո                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | եր                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ուր                                               | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1֊ին                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5֊րդ                                              | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | երկ                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ուրբ                                              | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | երկուշաբթի                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ուրբաթ                                            | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | Ե                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ո                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | եր                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ուր                                               | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1֊ին                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5֊րդ                                              | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | երկ                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ուրբ                                              | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | երկուշաբթի                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ուրբաթ                                            | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | Ե                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ո                                                 | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | եր                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ուր                                               | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | a.m.                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                              | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | a                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                 | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | a.m.                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                              | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | a                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                 | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | առավոտը                                           | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ցերեկը                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | երեկոյան                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | գիշերը                                            | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | առավոտը                                           | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ցերեկը                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | երեկոյան                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | գիշերը                                            | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | առավոտը                                           | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ցերեկը                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | երեկոյան                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | գիշերը                                            | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | առավոտը                                           | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ցերեկը                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | երեկոյան                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | գիշերը                                            | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | առավոտը                                           | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ցերեկը                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | երեկոյան                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | գիշերը                                            | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11֊րդ                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11֊րդ                                             | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11֊րդ                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23֊րդ                                             | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11֊րդ                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11֊րդ                                             | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11֊րդ                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23֊րդ                                             | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1֊ին                                              | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55֊րդ                                             | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1֊ին                                              | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55֊րդ                                             | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11.02.1987                                        | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453                                        | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 փետ, 1987                                      | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 մայ, 1453                                      | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11 փետրվար, 1987                                  | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 մայիս, 1453                                    | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | 11 փետրվար, 1987, չորեքշաբթի                      | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 մայիս, 1453, կիրակի                            | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                             | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                             | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                          | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                          | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                    | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                    | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                                | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11.02.1987, 12:13                                 | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453, 23:59                                 | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 փետ, 1987, 12:13:14                            | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 մայ, 1453, 23:59:59                            | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11 փետրվար, 1987 ժ․12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 մայիս, 1453 ժ․23:59:59 GMT+0                   | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | 11 փետրվար, 1987, չորեքշաբթի ժ․12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 մայիս, 1453, կիրակի ժ․23:59:59 GMT+00:00       | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result               | `includeSeconds: true`    | `addSuffix: true`         |
| ------------------------ | -------------------- | ------------------------- | ------------------------- |
| 2006-01-01T00:00:00.000Z | մոտ 6 տարի           | մոտ 6 տարի                | մոտ 6 տարի հետո           |
| 2005-01-01T00:00:00.000Z | մոտ 5 տարի           | մոտ 5 տարի                | մոտ 5 տարի հետո           |
| 2004-01-01T00:00:00.000Z | մոտ 4 տարի           | մոտ 4 տարի                | մոտ 4 տարի հետո           |
| 2003-01-01T00:00:00.000Z | մոտ 3 տարի           | մոտ 3 տարի                | մոտ 3 տարի հետո           |
| 2002-01-01T00:00:00.000Z | մոտ 2 տարի           | մոտ 2 տարի                | մոտ 2 տարի հետո           |
| 2001-06-01T00:00:00.000Z | ավելի քան 1 տարի     | ավելի քան 1 տարի          | ավելի քան 1 տարի հետո     |
| 2001-02-01T00:00:00.000Z | մոտ 1 տարի           | մոտ 1 տարի                | մոտ 1 տարի հետո           |
| 2001-01-01T00:00:00.000Z | մոտ 1 տարի           | մոտ 1 տարի                | մոտ 1 տարի հետո           |
| 2000-06-01T00:00:00.000Z | 5 ամիս               | 5 ամիս                    | 5 ամիս հետո               |
| 2000-03-01T00:00:00.000Z | 2 ամիս               | 2 ամիս                    | 2 ամիս հետո               |
| 2000-02-01T00:00:00.000Z | մոտ 1 ամիս           | մոտ 1 ամիս                | մոտ 1 ամիս հետո           |
| 2000-01-15T00:00:00.000Z | 14 օր                | 14 օր                     | 14 օր հետո                |
| 2000-01-02T00:00:00.000Z | 1 օր                 | 1 օր                      | 1 օր հետո                 |
| 2000-01-01T06:00:00.000Z | մոտ 6 ժամ            | մոտ 6 ժամ                 | մոտ 6 ժամ հետո            |
| 2000-01-01T01:00:00.000Z | մոտ 1 ժամ            | մոտ 1 ժամ                 | մոտ 1 ժամ հետո            |
| 2000-01-01T00:45:00.000Z | մոտ 1 ժամ            | մոտ 1 ժամ                 | մոտ 1 ժամ հետո            |
| 2000-01-01T00:30:00.000Z | 30 րոպե              | 30 րոպե                   | 30 րոպե հետո              |
| 2000-01-01T00:15:00.000Z | 15 րոպե              | 15 րոպե                   | 15 րոպե հետո              |
| 2000-01-01T00:01:00.000Z | 1 րոպե               | 1 րոպե                    | 1 րոպե հետո               |
| 2000-01-01T00:00:25.000Z | ավելի քիչ քան 1 րոպե | կես րոպե                  | ավելի քիչ քան 1 րոպե հետո |
| 2000-01-01T00:00:15.000Z | ավելի քիչ քան 1 րոպե | ավելի քիչ քան 20 վայրկյան | ավելի քիչ քան 1 րոպե հետո |
| 2000-01-01T00:00:05.000Z | ավելի քիչ քան 1 րոպե | ավելի քիչ քան 10 վայրկյան | ավելի քիչ քան 1 րոպե հետո |
| 2000-01-01T00:00:00.000Z | ավելի քիչ քան 1 րոպե | ավելի քիչ քան 5 վայրկյան  | ավելի քիչ քան 1 րոպե առաջ |
| 1999-12-31T23:59:55.000Z | ավելի քիչ քան 1 րոպե | ավելի քիչ քան 10 վայրկյան | ավելի քիչ քան 1 րոպե առաջ |
| 1999-12-31T23:59:45.000Z | ավելի քիչ քան 1 րոպե | ավելի քիչ քան 20 վայրկյան | ավելի քիչ քան 1 րոպե առաջ |
| 1999-12-31T23:59:35.000Z | ավելի քիչ քան 1 րոպե | կես րոպե                  | ավելի քիչ քան 1 րոպե առաջ |
| 1999-12-31T23:59:00.000Z | 1 րոպե               | 1 րոպե                    | 1 րոպե առաջ               |
| 1999-12-31T23:45:00.000Z | 15 րոպե              | 15 րոպե                   | 15 րոպե առաջ              |
| 1999-12-31T23:30:00.000Z | 30 րոպե              | 30 րոպե                   | 30 րոպե առաջ              |
| 1999-12-31T23:15:00.000Z | մոտ 1 ժամ            | մոտ 1 ժամ                 | մոտ 1 ժամ առաջ            |
| 1999-12-31T23:00:00.000Z | մոտ 1 ժամ            | մոտ 1 ժամ                 | մոտ 1 ժամ առաջ            |
| 1999-12-31T18:00:00.000Z | մոտ 6 ժամ            | մոտ 6 ժամ                 | մոտ 6 ժամ առաջ            |
| 1999-12-30T00:00:00.000Z | 2 օր                 | 2 օր                      | 2 օր առաջ                 |
| 1999-12-15T00:00:00.000Z | 17 օր                | 17 օր                     | 17 օր առաջ                |
| 1999-12-01T00:00:00.000Z | մոտ 1 ամիս           | մոտ 1 ամիս                | մոտ 1 ամիս առաջ           |
| 1999-11-01T00:00:00.000Z | 2 ամիս               | 2 ամիս                    | 2 ամիս առաջ               |
| 1999-06-01T00:00:00.000Z | 7 ամիս               | 7 ամիս                    | 7 ամիս առաջ               |
| 1999-01-01T00:00:00.000Z | մոտ 1 տարի           | մոտ 1 տարի                | մոտ 1 տարի առաջ           |
| 1998-12-01T00:00:00.000Z | մոտ 1 տարի           | մոտ 1 տարի                | մոտ 1 տարի առաջ           |
| 1998-06-01T00:00:00.000Z | ավելի քան 1 տարի     | ավելի քան 1 տարի          | ավելի քան 1 տարի առաջ     |
| 1998-01-01T00:00:00.000Z | մոտ 2 տարի           | մոտ 2 տարի                | մոտ 2 տարի առաջ           |
| 1997-01-01T00:00:00.000Z | մոտ 3 տարի           | մոտ 3 տարի                | մոտ 3 տարի առաջ           |
| 1996-01-01T00:00:00.000Z | մոտ 4 տարի           | մոտ 4 տարի                | մոտ 4 տարի առաջ           |
| 1995-01-01T00:00:00.000Z | մոտ 5 տարի           | մոտ 5 տարի                | մոտ 5 տարի առաջ           |
| 1994-01-01T00:00:00.000Z | մոտ 6 տարի           | մոտ 6 տարի                | մոտ 6 տարի առաջ           |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result      | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ----------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 տարի      | 6 տարի հետո       | 52608 ժամ                      |
| 2005-01-01T00:00:00.000Z | 5 տարի      | 5 տարի հետո       | 43848 ժամ                      |
| 2004-01-01T00:00:00.000Z | 4 տարի      | 4 տարի հետո       | 35064 ժամ                      |
| 2003-01-01T00:00:00.000Z | 3 տարի      | 3 տարի հետո       | 26304 ժամ                      |
| 2002-01-01T00:00:00.000Z | 2 տարի      | 2 տարի հետո       | 17544 ժամ                      |
| 2001-06-01T00:00:00.000Z | 1 տարի      | 1 տարի հետո       | 12408 ժամ                      |
| 2001-02-01T00:00:00.000Z | 1 տարի      | 1 տարի հետո       | 9528 ժամ                       |
| 2001-01-01T00:00:00.000Z | 1 տարի      | 1 տարի հետո       | 8784 ժամ                       |
| 2000-06-01T00:00:00.000Z | 5 ամիս      | 5 ամիս հետո       | 3648 ժամ                       |
| 2000-03-01T00:00:00.000Z | 2 ամիս      | 2 ամիս հետո       | 1440 ժամ                       |
| 2000-02-01T00:00:00.000Z | 1 ամիս      | 1 ամիս հետո       | 744 ժամ                        |
| 2000-01-15T00:00:00.000Z | 14 օր       | 14 օր հետո        | 336 ժամ                        |
| 2000-01-02T00:00:00.000Z | 1 օր        | 1 օր հետո         | 24 ժամ                         |
| 2000-01-01T06:00:00.000Z | 6 ժամ       | 6 ժամ հետո        | 6 ժամ                          |
| 2000-01-01T01:00:00.000Z | 1 ժամ       | 1 ժամ հետո        | 1 ժամ                          |
| 2000-01-01T00:45:00.000Z | 45 րոպե     | 45 րոպե հետո      | 1 ժամ                          |
| 2000-01-01T00:30:00.000Z | 30 րոպե     | 30 րոպե հետո      | 1 ժամ                          |
| 2000-01-01T00:15:00.000Z | 15 րոպե     | 15 րոպե հետո      | 0 ժամ                          |
| 2000-01-01T00:01:00.000Z | 1 րոպե      | 1 րոպե հետո       | 0 ժամ                          |
| 2000-01-01T00:00:25.000Z | 25 վայրկյան | 25 վայրկյան հետո  | 0 ժամ                          |
| 2000-01-01T00:00:15.000Z | 15 վայրկյան | 15 վայրկյան հետո  | 0 ժամ                          |
| 2000-01-01T00:00:05.000Z | 5 վայրկյան  | 5 վայրկյան հետո   | 0 ժամ                          |
| 2000-01-01T00:00:00.000Z | 0 վայրկյան  | 0 վայրկյան առաջ   | 0 ժամ                          |
| 1999-12-31T23:59:55.000Z | 5 վայրկյան  | 5 վայրկյան առաջ   | 0 ժամ                          |
| 1999-12-31T23:59:45.000Z | 15 վայրկյան | 15 վայրկյան առաջ  | 0 ժամ                          |
| 1999-12-31T23:59:35.000Z | 25 վայրկյան | 25 վայրկյան առաջ  | 0 ժամ                          |
| 1999-12-31T23:59:00.000Z | 1 րոպե      | 1 րոպե առաջ       | 0 ժամ                          |
| 1999-12-31T23:45:00.000Z | 15 րոպե     | 15 րոպե առաջ      | 0 ժամ                          |
| 1999-12-31T23:30:00.000Z | 30 րոպե     | 30 րոպե առաջ      | 1 ժամ                          |
| 1999-12-31T23:15:00.000Z | 45 րոպե     | 45 րոպե առաջ      | 1 ժամ                          |
| 1999-12-31T23:00:00.000Z | 1 ժամ       | 1 ժամ առաջ        | 1 ժամ                          |
| 1999-12-31T18:00:00.000Z | 6 ժամ       | 6 ժամ առաջ        | 6 ժամ                          |
| 1999-12-30T00:00:00.000Z | 2 օր        | 2 օր առաջ         | 48 ժամ                         |
| 1999-12-15T00:00:00.000Z | 17 օր       | 17 օր առաջ        | 408 ժամ                        |
| 1999-12-01T00:00:00.000Z | 1 ամիս      | 1 ամիս առաջ       | 744 ժամ                        |
| 1999-11-01T00:00:00.000Z | 2 ամիս      | 2 ամիս առաջ       | 1464 ժամ                       |
| 1999-06-01T00:00:00.000Z | 7 ամիս      | 7 ամիս առաջ       | 5136 ժամ                       |
| 1999-01-01T00:00:00.000Z | 1 տարի      | 1 տարի առաջ       | 8760 ժամ                       |
| 1998-12-01T00:00:00.000Z | 1 տարի      | 1 տարի առաջ       | 9504 ժամ                       |
| 1998-06-01T00:00:00.000Z | 2 տարի      | 2 տարի առաջ       | 13896 ժամ                      |
| 1998-01-01T00:00:00.000Z | 2 տարի      | 2 տարի առաջ       | 17520 ժամ                      |
| 1997-01-01T00:00:00.000Z | 3 տարի      | 3 տարի առաջ       | 26280 ժամ                      |
| 1996-01-01T00:00:00.000Z | 4 տարի      | 4 տարի առաջ       | 35064 ժամ                      |
| 1995-01-01T00:00:00.000Z | 5 տարի      | 5 տարի առաջ       | 43824 ժամ                      |
| 1994-01-01T00:00:00.000Z | 6 տարի      | 6 տարի առաջ       | 52584 ժամ                      |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                     |
| ------------------------ | -------------------------- |
| 2000-01-10T00:00:00.000Z | 10.01.2000                 |
| 2000-01-05T00:00:00.000Z | հաջորդ չորեքշաբթի 00:00֊ին |
| 2000-01-02T00:00:00.000Z | վաղը 00:00֊ին              |
| 2000-01-01T00:00:00.000Z | այսօր 00:00֊ին             |
| 1999-12-31T00:00:00.000Z | երեկ 00:00֊ին              |
| 1999-12-27T00:00:00.000Z | նախորդ երկուշաբթի 00:00֊ին |
| 1999-12-21T00:00:00.000Z | 21.12.1999                 |
