"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.withProtectedRoutesHandler = void 0;
const admin_bro_1 = require("admin-bro");
const withProtectedRoutesHandler = (router, admin) => {
    const { rootPath } = admin.options;
    router.use((req, res, next) => {
        if (admin_bro_1.Router.assets.find((asset) => req.originalUrl.match(asset.path))) {
            next();
        }
        else if (req.session.adminUser ||
            // these routes doesn't need authentication
            req.originalUrl.startsWith(admin.options.loginPath) ||
            req.originalUrl.startsWith(admin.options.logoutPath)) {
            next();
        }
        else {
            // If the redirection is caused by API call to some action just redirect to resource
            const [redirectTo] = req.originalUrl.split("/actions");
            req.session.redirectTo = redirectTo.includes(`${rootPath}/api`)
                ? rootPath
                : redirectTo;
            req.session.save((err) => {
                if (err) {
                    next(err);
                }
                res.redirect(admin.options.loginPath);
            });
        }
    });
};
exports.withProtectedRoutesHandler = withProtectedRoutesHandler;
//# sourceMappingURL=protected-routes.handler.js.map