/**
 * Resets css styles which can be applied to element created by styled-component
 *
 * ### Example
 *
 * ```javascript
 * import { reset } from '@admin-bro/design-system'
 *
 * const myContentComponent = styled`
 *   ${reset};
 * `
 * ```
 * @new in version 3.3
 * @memberof module:@admin-bro/design-system
 */
declare const reset: import("styled-components").FlattenSimpleInterpolation;
/**
 * Resets css component which should be applied to the top of the html
 *
 * ### Example
 *
 * ```jsx
 * import { Reset } from '@admin-bro/design-system'
 *
 * <ThemeProvider theme={theme}>
 *   <Reset />
 *   <Box>
 *     { ... }
 *   </Box>
 * </ThemeProvider>
 * ```
 * @new in version 3.3
 * @memberof module:@admin-bro/design-system
 */
declare const Reset: import("styled-components").GlobalStyleComponent<{}, import("styled-components").DefaultTheme>;
export { Reset, reset, };
